<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterProjectSplitsType" />
 <xsl:param name="ParameterCHMSplitFileType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:variable name="GlobalDefaultNamespace" select="'http://www.w3.org/1999/xhtml'" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/companyinfo/companyinfo_content.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />
 <xsl:include href="wwtransform:uri/uri.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-splits-by-groupid" match="wwsplits:Split" use="@groupID" />
 <xsl:key name="wwproject-formatconfigurations-by-targetid" match="wwproject:FormatConfiguration" use="@TargetID" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/companyinfo/companyinfo_content.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:uri/uri.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:uri/uri.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Project Splits -->
 <!--                -->
 <xsl:variable name="GlobalProjectSplitsPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectSplitsType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectSplits" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectSplitsPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Merge -->
   <!--       -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:if test="count($VarProjectGroups) &gt; 1">
    <xsl:for-each select="$GlobalProject[1]">
     <!-- Default Page Rule -->
     <!--                   -->
     <xsl:variable name="VarDefaultPageRule" select="wwprojext:GetRule('Page', '')" />
     <xsl:variable name="VarExtensionOption" select="$VarDefaultPageRule/wwproject:Options/wwproject:Option[@Name = 'file-extension']/@Value" />
     <xsl:variable name="VarExtension">
      <xsl:choose>
       <xsl:when test="string-length($VarExtensionOption) &gt; 0">
        <xsl:value-of select="$VarExtensionOption" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="'.html'" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:variable>

     <xsl:variable name="VarFormatConfiguration" select="key('wwproject-formatconfigurations-by-targetid', wwprojext:GetFormatID())[1]" />
     <xsl:variable name="VarMergeSettings" select="$VarFormatConfiguration/wwproject:MergeSettings" />
     <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), concat(wwprojext:GetFormatName(), $VarExtension))" />

     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups)), '', '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <xsl:call-template name="MergePage">
        <xsl:with-param name="ParamMergePath" select="$VarMergePath" />
        <xsl:with-param name="ParamMergeSettings" select="$VarMergeSettings" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarMergePath, wwprojext:GetFormatSetting('encoding', 'ISO-8859-1'), 'xhtml', '1.0', 'yes', 'yes', '', '-//W3C//DTD XHTML 1.0 Transitional//EN', 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd', '', 'text/html')" />
     </xsl:if>

     <wwfiles:File path="{$VarMergePath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups))}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
      <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
     </wwfiles:File>
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="MergePage">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamMergeSettings" />

  <xsl:variable name="VarLocale" select="wwprojext:GetFormatSetting('locale', 'en')" />

  <xsl:variable name="VarTitle">
   <xsl:choose>
    <xsl:when test="string-length($ParamMergeSettings/@Title) &gt; 0">
     <xsl:value-of select="$ParamMergeSettings/@Title" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="wwprojext:GetFormatName()" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <html:html xml:lang="{$VarLocale}" lang="{$VarLocale}">
   <html:head>
    <html:meta http-equiv="Content-Type" content="{concat('text/html; charset=', wwprojext:GetFormatSetting('encoding', 'ISO-8859-1'))}" />

    <html:title>
     <xsl:value-of select="$VarTitle" />
    </html:title>
   </html:head>

   <html:body>
    <!-- Link to CHM files -->
    <!--                   -->
    <html:dl>
     <xsl:apply-templates select="$ParamMergeSettings/wwproject:*" mode="wwmode:merge">
      <xsl:with-param name="ParamPath" select="$ParamPath" />
     </xsl:apply-templates>
    </html:dl>

    <!-- Must include at least one ALink keyword for contained alinks to work -->
    <!--                                                                      -->
    <html:object type="application/x-oleobject" classid="clsid:1e2a7bd0-dab9-11d0-b93a-00c04fc99f9e">
     <html:param name="ALink Name" value="WebWorksPublisher_Merge_Required_ALink" />
    </html:object>
   </html:body>
  </html:html>
 </xsl:template>


 <xsl:template match="wwproject:TOC" mode="wwmode:merge">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamTOC" select="." />

  <html:dd>
   <xsl:value-of select="$ParamTOC/@Name" />

   <html:dl>
    <xsl:apply-templates mode="wwmode:merge">
     <xsl:with-param name="ParamPath" select="$ParamPath" />
    </xsl:apply-templates>
   </html:dl>
  </html:dd>
 </xsl:template>


 <xsl:template match="wwproject:MergeGroup" mode="wwmode:merge">
  <xsl:param name="ParamPath" />
  <xsl:param name="ParamMergeGroup" select="." />

  <html:dd>
   <xsl:variable name="VarGroupName" select="wwprojext:GetGroupName($ParamMergeGroup/@GroupID)" />

   <xsl:variable name="VarTitle">
    <xsl:choose>
     <xsl:when test="string-length($ParamMergeGroup/@Title) &gt; 0">
      <xsl:value-of select="$ParamMergeGroup/@Title" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$VarGroupName" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>

   <xsl:for-each select="$GlobalProjectSplits[1]">
    <xsl:variable name="VarCHMSplit" select="key('wwsplits-files-by-groupid-type', concat($ParamMergeGroup/@GroupID, ':', $ParameterCHMSplitFileType))[1]" />
    <xsl:variable name="VarPageSplit" select="key('wwsplits-splits-by-groupid', $ParamMergeGroup/@GroupID)[1]" />
    <xsl:variable name="VarCHMRelativePath" select="wwfilesystem:GetFileName($VarCHMSplit/@path)" />
    <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarGroupName, 'dummy.component')" />
    <xsl:variable name="VarPageRelativePath" select="wwuri:GetRelativeTo($VarPageSplit/@path, $VarGroupOutputDirectoryPath)" />

    <xsl:variable name="VarPageLink" select="concat('ms-its:', $VarCHMRelativePath, '::/', $VarPageRelativePath)" />

    <html:a href="{$VarPageLink}">
     <xsl:value-of select="$VarTitle" />
    </html:a>
   </xsl:for-each>
  </html:dd>
 </xsl:template>
</xsl:stylesheet>
